#pragma once
#include "Renderable.h"
#include <GL/glew.h>
#include <GL/GL.h>

namespace graphics {
	/*!
		Creates a pyramid mesh
	*/
	class PyramidMesh :
		public Renderable
	{
	public:
		PyramidMesh();
		PyramidMesh(const PyramidMesh & pyramid) = delete;
		PyramidMesh & operator = (const PyramidMesh & pyramid) = delete;
		~PyramidMesh();
		void render();
	private:
		GLuint m_VAO;
		/*
			0 -> vertex buffer
			1 -> index buffer
		*/
		GLuint m_buffers[2];
	};

};

